// ===========================================================================
//	LInternetResponse.cp		PowerPlant 2.2.1	1996-1999 Metrowerks Inc.
// ===========================================================================
//
//	Base class for handling typical Internet style protocol responses which
//	include a response number, and associated text response.

#ifdef PowerPlant_PCH
	#include PowerPlant_PCH
#endif
#include "PP_Prefix.h"

#include "LInternetResponse.h"

PP_Begin_Namespace_PowerPlant


// ---------------------------------------------------------------------------
//	 LInternetResponse						Default Constructor
// ---------------------------------------------------------------------------

LInternetResponse::LInternetResponse()
{
	InitResponse();
}


// ---------------------------------------------------------------------------
//	 LInternetResponse						Copy Constructor
// ---------------------------------------------------------------------------

LInternetResponse::LInternetResponse(const LInternetResponse& copyResponse)

	: mResponseText(copyResponse.mResponseText)
{
	mResponseCode = copyResponse.mResponseCode;
}


// ---------------------------------------------------------------------------
//	 operator =							Assignment Operator
// ---------------------------------------------------------------------------

LInternetResponse&
LInternetResponse::operator = (const LInternetResponse& copyResponse)
{
	mResponseCode = copyResponse.mResponseCode;
	mResponseText = copyResponse.mResponseText;

	return *this;
}


// ---------------------------------------------------------------------------
//	 ~LInternetResponse					Destructor
// ---------------------------------------------------------------------------

LInternetResponse::~LInternetResponse()
{
}


// ---------------------------------------------------------------------------
//	 InitResponse()
// ---------------------------------------------------------------------------

void
LInternetResponse::InitResponse()
{
	mResponseCode = 0;
	mResponseText = "";
}

PP_End_Namespace_PowerPlant
